/*
 * Decompiled with CFR 0.152.
 */
package alerter;

import alerter.Connection;
import alerter.Email;
import alerter.Persist;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Alerter {
    private static final int DEFAULT_POLL_INTERVAL = 300;
    private Connection connection;
    private Email email;
    private DocumentBuilder docBuilder;
    private Persist persist;
    private String lastId;
    private int pollInterval = 300;

    public static void main(String[] stringArray) {
        Alerter alerter = new Alerter();
        alerter.processArgs(stringArray);
        alerter.run();
    }

    private Alerter() {
        try {
            this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            System.out.println("Couldn't create document builder: " + exception);
            System.exit(1);
        }
    }

    private void run() {
        String string;
        while ((string = this.connection.getAlerts(this.lastId)).length() != 0) {
            this.processAlerts(string);
            try {
                Thread.sleep(this.pollInterval * 1000);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private void processArgs(String[] stringArray) {
        String string = "localhost";
        int n = 8090;
        String string2 = "alerter";
        String string3 = "alerter";
        String string4 = "../../conf/alerter_state.properties";
        String string5 = "mail";
        int n2 = 25;
        String string6 = null;
        String string7 = null;
        String string8 = "LicenseManagerAlerter";
        String string9 = "LicenseManagerAlerts";
        String string10 = "-host";
        String string11 = "-interval";
        String string12 = "-password";
        String string13 = "-persist";
        String string14 = "-port";
        String string15 = "-fromAddress";
        String string16 = "-smtpPassword";
        String string17 = "-smtpPort";
        String string18 = "-smtpServer";
        String string19 = "-toAddress";
        String string20 = "-smtpUser";
        String string21 = "-user";
        for (int i = 0; i < stringArray.length; ++i) {
            String string22 = stringArray[i++];
            if (i >= stringArray.length) {
                this.usage();
            }
            String string23 = stringArray[i];
            if (string22.equals(string10)) {
                string = string23;
                continue;
            }
            if (string22.equals(string14)) {
                n = Integer.valueOf(string23);
                continue;
            }
            if (string22.equals(string21)) {
                string2 = string23;
                continue;
            }
            if (string22.equals(string12)) {
                string3 = string23;
                continue;
            }
            if (string22.equals(string13)) {
                string4 = string23;
                continue;
            }
            if (string22.equals(string18)) {
                string5 = string23;
                continue;
            }
            if (string22.equals(string17)) {
                n2 = Integer.valueOf(string23);
                continue;
            }
            if (string22.equals(string20)) {
                string6 = string23;
                continue;
            }
            if (string22.equals(string16)) {
                string7 = string23;
                continue;
            }
            if (string22.equals(string15)) {
                string8 = string23;
                continue;
            }
            if (string22.equals(string19)) {
                string9 = string23;
                continue;
            }
            if (string22.equals(string11)) {
                this.pollInterval = Integer.valueOf(string23);
                continue;
            }
            this.usage();
        }
        this.connection = new Connection(string, n, string2, string3);
        this.email = new Email(string5, n2, string6, string7, string8, string9);
        this.persist = new Persist(string4);
        this.lastId = this.persist.getLastId();
    }

    private void processAlerts(String string) {
        Document document;
        try {
            document = this.docBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            System.out.println("Problem parsing alert: " + exception);
            return;
        }
        NodeList nodeList = document.getElementsByTagName("fnplm:alert");
        String string2 = this.lastId;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string3 = element.getAttribute("id");
            if (string3.compareTo(string2) > 0) {
                string2 = string3;
            }
            String string4 = element.getAttribute("title");
            String string5 = element.getAttribute("description");
            String string6 = element.getAttribute("level");
            String string7 = element.getAttribute("timestamp");
            System.out.println("Title : " + string4 + "\n Description:" + string5 + " \n Level: " + string6 + "\n timestamp: " + string7 + "\n");
            this.email.send(string4, string5, string6, string7);
        }
        if (string2.compareTo(this.lastId) > 0) {
            this.lastId = string2;
            this.persist.setLastId(this.lastId);
        }
    }

    private void usage() {
        System.out.println("Usage: runalerter [-host <lmadmin-host>] [-port <lmadmin-http-port>]\n                  [-user <lmadmin-user>] [-password <lmadmin-password>]\n                  [-smtpServer <smtp-host>] [-smtpPort <smtp-port>]\n                  [-smtpUser <smtp-user>] [-smtpPassword <smtp-password>]\n                  [-fromAddress <email-from>] [-toAddress <email-to>]\n                  [-persist <alerter-saved-state-file> -interval <seconds>]\n\nwhere:\n\n    -host <lmadmin-host>\n        Specifies the host that the lmadmin is running on.\n        Defaults to 'localhost'.\n\n    -port <lmadmin-http-port>\n        Specifies the HTTP port that the lmadmin is running on.\n        Defaults to '8090'.\n\n    -user <lmadmin-user>\n        Specifies the user that will be used to connect to the lmadmin\n        web service.  Defaults to 'alerter'.\n\n    -password <lmadmin-password>\n        Specifies the password that will be used to connect to the\n        lmadmin web service.  Defaults to 'alerter'.\n\n    -smtpServer <smtp-host>\n        Specifies the host that the SMTP server is running on.\n        Defaults to 'mail'.\n\n    -smtpPort <smtp-port>\n        Specifies the host that the SMTP server is running on.\n        Defaults to '25'.\n\n    -smtpUser <smtp-user>\n        Specifies the user that will be used to connect to the SMTP\n        mail sever.  Defaults to none.\n\n    -smtpPassword <smtp-password>\n        Specifies the password that will be used to connect to the\n        mail sever.  Defaults to none.\n\n    -fromAddress <email-from>\n        Specifies the from address for alert emails.\n        Defaults to 'LicenseManagerAlerter'.\n\n    -toAddress <email-to>\n        Specifies the to address for alert emails (normally an alias).\n        Defaults to 'LicenseManagerAlerts'.\n\n    -persist <alerter-saved-state-file>\n        The file to save alerter state in (last alert processed).\n        Defaults to '../../conf/alerter_state.properties'.\n\n    -interval <seconds>\n        The number of seconds to wait between checks for new alerts.\n        Defaults to 300 (five minutes).");
        System.exit(1);
    }
}

