;/**************************************************************************************************
;*Copyright (c) 1997-2016, 2018 Flexera. All Rights Reserved.
;**************************************************************************************************/


;// FNPlm Event Log Message File
;//----------------------------

;// Message ID Type
;//----------------

MessageIdTypedef=DWORD

;// Severity Names
;//---------------

SeverityNames=(Success       = 0x0:STATUS_SEVERITY_SUCCESS
               Informational = 0x1:STATUS_SEVERITY_INFORMATIONAL
               Warning       = 0x2:STATUS_SEVERITY_WARNING
               Error         = 0x3:STATUS_SEVERITY_ERROR)

;// Facility Names
;//---------------

FacilityNames=(System  = 0x0:FACILITY_SYSTEM
               Runtime = 0x2:FACILITY_RUNTIME
               Stubs   = 0x3:FACILITY_STUBS
               Io      = 0x4:FACILITY_IO_ERROR_CODE)

;// Language Support
;//-----------------

LanguageNames=(English = 0x409:FnplmLicenseServerMsgs409)


;// Message categories
;//-------------------
MessageId=0x1
Severity=Success
SymbolicName=CAT_FLEXLM_LMADMIN
Language=English
FlexNet License Server
.

MessageId=0x2
Severity=Success
SymbolicName=CAT_FLEXLM_SERVER_EVENT
Language=English
FlexNet License Server System Event
.

MessageId=0x3
Severity=Success
SymbolicName=CAT_FLEXLM_LICENSE_FILE
Language=English
FlexNet License File
.

MessageId=0x4
Severity=Success
SymbolicName=CAT_FLEXLM_NETWORK_COMM
Language=English
FlexNet Network Communications
.

MessageId=0x5
Severity=Success
SymbolicName=CAT_FLEXLM_LMADMIN_HEALTH
Language=English
FlexNet License Server Manager Health
.

MessageId=0x6
Severity=Success
SymbolicName=CAT_FLEXLM_LMADMIN_EVENT
Language=English
FlexNet License Server Manager Event
.


;// Message definitions
;//--------------------
MessageId=0x2DC
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_WIN32_SERVICE_STOPPED
Language=English
(%1) FlexNet License Server System is shutting down.
.

MessageId=0x2F3
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_SHUTDOWN
Language=English
(%1) Shutting down vendor daemon:  %2, on node: %3
.

MessageId=0x400
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_SHUTDOWN_ERROR
Language=English
(%1) Unable to shutdown vendor daemon: %2, on node: %3
.

MessageId=0x2D1
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_EVENT_LOG_ACTIVE
Language=English
(%1) FlexNet License Server Manager started.
.

MessageId=0x2DE
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_STARTMSG
Language=English
(%1) FlexNet (v%2.%3.%4) started on %5 (%6) (%7).
.

MessageId=0x2F1
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_LICENSE_FILE
Language=English
(%1) The license server (lmadmin) is using license file: %2.
.

MessageId=0x2EF
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_PORT
Language=English
(%1) The license server (lmadmin) is using TCP-port: %2.
.

MessageId=0x2D2
Severity=Error
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_DAEMON_NOT_FOUND
Language=English
(%1) The license server (lmadmin) cannot find the binary (%2)
for vendor %3.  Request to start ignored.
.

MessageId=0x301
Severity=Error
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_PORT_OPEN_FAILED
Language=English
(%1) The license server (lmadmin) failed to open the 
TCP/IP port number specified in the license file.
.

MessageId=0x2EC
Severity=Error
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_BAD_CHECKSUM
Language=English
(%1) Received packet with bad checksum.
.

MessageId=0x2F2
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_SHUTDOWN_REQ
Language=English
(%1) License server (lmadmin) shutdown request from %2 at node: %3
.


MessageId=0x404
Severity=Informational
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_VENDOR_STARTED
Language=English
(%1) Vendor %2 (v%3.%4) successfully started.
.

MessageId=0x2F5
Severity=Error
Facility=System
SymbolicName=MSG_FLEXLM_LMADMIN_WIN32_SERVICE_STARTUP_FAILURE
Language=English
(%1) License Server failed to start as a service. Set the environment variable FORCE_NO_SERVICE to 1 to start it as a console process.
.


