<?xml version="1.0" encoding="UTF-8" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:extensions="urn:fnplm:lmadmin" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions" xmlns:fnplm="urn:fnplm:lmadmin">
<xsl:param name="host" select="'systemName1'"/>
<xsl:output method="xml" version="4.01" encoding="UTF-8" omit-xml-declaration="yes"/>
<xsl:output indent="yes"/>

<xsl:template match="xml">
<xml>
<xsl:apply-templates select="fnplm:products"/>
<xsl:apply-templates select="fnplm:env"/>
</xml>
</xsl:template>

<xsl:template match="fnplm:hosts">
            <xsl:apply-templates select="fnplm:host[@name=$host]"/>
</xsl:template>

<xsl:template match="fnplm:host">
    <fnplm:detail>
        <xsl:attribute name="vendorname"><xsl:value-of select="//fnplm:products/@vendorname"/></xsl:attribute>
        <xsl:attribute name="productname"><xsl:value-of select="../@productname"/></xsl:attribute>
        <xsl:attribute name="productversion"><xsl:value-of select="../@versionname"/></xsl:attribute>
        <xsl:attribute name="productid"><xsl:value-of select="../@entitlementid"/></xsl:attribute>
        <xsl:attribute name="fulfillmentrecordid"><xsl:value-of select="@deductionid"/></xsl:attribute>
    </fnplm:detail>
</xsl:template>

<xsl:template match="fnplm:env">
<xsl:copy>
    <xsl:copy-of select="@*"/>
</xsl:copy>

</xsl:template>

<xsl:template match="fnplm:products">
    <fnplm:host>
            <xsl:attribute name="hostname"><xsl:value-of select="$host"/></xsl:attribute>
            <xsl:apply-templates select="fnplm:hosts"/>
    </fnplm:host>
</xsl:template>

</xsl:stylesheet>

