<?xml version="1.0" encoding="UTF-8" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:extensions="urn:fnplm:lmadmin" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">

  <xsl:output method="xml" version="4.01" encoding="UTF-8" omit-xml-declaration="yes"/>
  <xsl:output indent="yes"/>

  <xsl:param name="vendorName" select="'demo'"/>
  <xsl:key name="products" match="fnplm:product" use="@productname"/>

  <xsl:template match="/">
    <xml>
      <fnplm:products xmlns:fnplm="urn:fnplm:lmadmin">
        <xsl:attribute name="vendorname">
          <xsl:value-of select="$vendorName"/>
        </xsl:attribute>
        
        <xsl:for-each select="/xml/fnplm:products/fnplm:product[generate-id(.)=generate-id(key('products', @productname))]">
          <xsl:sort/>
          <fnplm:product>
            <xsl:copy-of select="@*"/>
            <xsl:for-each select="key('products', ./@productname)">
              <xsl:sort/>

              <fnplm:version>
                <xsl:copy-of select="./fnplm:version/@*"/>
              </fnplm:version>
            </xsl:for-each>
          </fnplm:product>
        </xsl:for-each>

      </fnplm:products>
    </xml>
  </xsl:template>
</xsl:stylesheet>

