<?xml version="1.0" encoding="UTF-8" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:extensions="urn:fnplm:lmadmin" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions">
<xsl:output method="xml" version="4.01" encoding="UTF-8" omit-xml-declaration="yes"/>
<xsl:output indent="yes"/>
<xsl:param name="host" select="''"/>
<xsl:param name="productid" select="'EZCALC'"/>

<xsl:template match="xml">
<xsl:variable name="totalRecords" select="count(//fnplm:hosts/*)"/>
    <xml>
        <xsl:apply-templates select="fnplm:hosts"/>
        <fnplm:input> 
          <xsl:attribute name="pageOffset">
               <xsl:value-of select="0"/>
          </xsl:attribute>
          <xsl:attribute name="pageSize">
               <xsl:value-of select="$totalRecords"/> 
          </xsl:attribute>
          <xsl:attribute name="totalRecords">
               <xsl:value-of select="$totalRecords"/> 
          </xsl:attribute>
          <xsl:attribute name="search">
               <xsl:value-of select="$host"/> 
          </xsl:attribute>
        </fnplm:input> 
    </xml>
</xsl:template>

<xsl:template match="fnplm:hosts">
    <fnplm:hosts>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="fnplm:host[contains(translate(@name,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ'), translate($host, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'))]"/> 
    </fnplm:hosts>
</xsl:template>

<xsl:template match="fnplm:host">
        <fnplm:host>
            <xsl:copy-of select="@*"/>
        </fnplm:host>
</xsl:template>
</xsl:stylesheet>
