<?xml version="1.0" encoding="UTF-8" ?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:extensions="urn:fnplm:lmadmin" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="exsl">
<xsl:output method="xml" version="4.01" encoding="UTF-8" omit-xml-declaration="yes"/>
<xsl:output indent="yes"/>

<xsl:param name="featurename" select="''"/>
<xsl:param name="versionname" select="''"/>
<xsl:param name="pageOffset" select="'-1'"/>
<xsl:param name="sortAttr" select="'@username'"/>
<xsl:param name="pageSize" select="'1'"/>
<xsl:param name="sortDir" select="'ascending'"/>

<xsl:template match="/">
<xsl:variable name="unsortedrows">
    <xsl:apply-templates/>
</xsl:variable>

<xsl:variable name="totalRecords" select="count(exsl:node-set($unsortedrows)/xml/fnplm:hosts/*)"/>

<xml>
<xsl:for-each select="exsl:node-set($unsortedrows)/xml">
    <fnplm:hosts>
        <xsl:copy-of select="fnplm:hosts/@*"/>
        <xsl:for-each select="exsl:node-set($unsortedrows)/xml/fnplm:hosts/fnplm:host">
            <xsl:sort select="xalan:evaluate($sortAttr)" order="{$sortDir}"/>
            <xsl:choose>
                <xsl:when test="$pageOffset='-1'">
                    <xsl:copy>
                        <xsl:copy-of select="@*"/>
                    </xsl:copy>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="position() &gt; $pageSize * number($pageOffset) and position() &lt;= number($pageSize * number($pageOffset) + $pageSize)">
                        <xsl:copy>
                            <xsl:copy-of select="@*"/>
                        </xsl:copy>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:for-each>
     </fnplm:hosts>
</xsl:for-each>

<fnplm:input> 
  <xsl:attribute name="pageOffset">
       <xsl:value-of select="$pageOffset"/>
  </xsl:attribute>
  <xsl:attribute name="pageSize">
       <xsl:value-of select="$pageSize"/> 
  </xsl:attribute>
  <xsl:attribute name="totalRecords">
       <xsl:value-of select="$totalRecords"/> 
  </xsl:attribute>
  <xsl:attribute name="sortAttr">
       <xsl:value-of select="substring($sortAttr, 2)"/> 
  </xsl:attribute>
  <xsl:attribute name="sortDir">
       <xsl:value-of select="$sortDir"/> 
  </xsl:attribute>
</fnplm:input> 

</xml>
</xsl:template>

<xsl:template match="xml">
<xml>
<xsl:apply-templates select="fnplm:features"/>
<xsl:apply-templates select="fnplm:env"/>
</xml>
</xsl:template>

<xsl:template match="fnplm:hosts">
    <xsl:param name="vendorname"/>
    <fnplm:hosts>
            <xsl:copy-of select="@*"/>
            <xsl:attribute name="vendorname">
               <xsl:value-of select="$vendorname"/>
            </xsl:attribute>
            <xsl:attribute name="versionname">
               <xsl:value-of select="$versionname"/>
            </xsl:attribute>
            <xsl:copy-of select="current()/*[@versionname=$versionname]"/>
    </fnplm:hosts>
</xsl:template>

<xsl:template match="fnplm:env">
<xsl:copy>
    <xsl:copy-of select="@*"/>
</xsl:copy>
</xsl:template>

<xsl:template match="fnplm:features">
   <xsl:apply-templates select="fnplm:hosts[@featurename=$featurename]">
      <xsl:with-param name="vendorname" select="@vendorname"/>
   </xsl:apply-templates>
</xsl:template>

</xsl:stylesheet>

