<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="licenseTab"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="selected"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes" /></xsl:param>

  <xsl:template match="/" name="adminAlertsForm">
    <script language="javascript">
      function submitAlertConfigForm(eventParam) {
        document.alertsForm.elements["event"].value = eventParam;
        
        if (eventParam != 'cancel') {
          var errors = false
          var errorString =  "<xsl:value-of select="extensions:getString('IDS_ALERTS_CONFIG_ERRORS')" disable-output-escaping="yes"/>";
        
          if (!document.alertsForm["ACTIVATION_THRESHOLD.threshold"].value.match(/^\d+$/) || document.alertsForm["ACTIVATION_THRESHOLD.threshold"].value <xsl:text disable-output-escaping="yes">&gt;</xsl:text> 100) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_ACTIVATION_THRESHOLD_PERCENTAGE_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.alertsForm["ACTIVATION_EXPIRE_THRESHOLD.threshold"].value.match(/^\d+$/)) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_ACTIVATION_EXPIRE_THRESHOLD_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.alertsForm["CONCURRENT_THRESHOLD.threshold"].value.match(/^\d+$/) || document.alertsForm["CONCURRENT_THRESHOLD.threshold"].value <xsl:text disable-output-escaping="yes">&gt;</xsl:text> 100) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CONCURRENT_THRESHOLD_PERCENTAGE_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.alertsForm["CONCURRENT_EXPIRE_THRESHOLD.threshold"].value.match(/^\d+$/)) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CONCURRENT_EXPIRE_THRESHOLD_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (!document.alertsForm["CONCURRENT_VERSION_EXPIRE.threshold"].value.match(/^\d+$/)) {
            errorString += "\n - <xsl:value-of select="extensions:getString('IDS_CONCURRENT_VERSION_EXPIRE_INVALID')" disable-output-escaping="yes"/>";
            errors = true;
          }
        
          if (errors) {
            alert(errorString);
            return false;
          }
        }
        
        document.alertsForm.submit();
        
        return false;
      }
    </script>
    <xsl:param name="vendorDownDisplay">
      <xsl:value-of select="//fnplm:item[@category='VENDOR_DAEMON_DOWN' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="vendorCouldNotStartDisplay">
      <xsl:value-of select="//fnplm:item[@category='VENDOR_DAEMON_COULD_NOT_START' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="limitDisplay">
      <xsl:value-of select="//fnplm:item[@category='ACTIVATION_LIMIT' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="thresholdDisplay">
      <xsl:value-of select="//fnplm:item[@category='ACTIVATION_THRESHOLD' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="thresholdValue">
      <xsl:value-of select="//fnplm:item[@category='ACTIVATION_THRESHOLD' and @name='threshold']/@value"/>
    </xsl:param>
    <xsl:param name="overdraftDisplay">
      <xsl:value-of select="//fnplm:item[@category='OVERDRAFT' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="overdraftLimitDisplay">
      <xsl:value-of select="//fnplm:item[@category='OVERDRAFT_LIMIT' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="activationExpireThresholdDisplay">
      <xsl:value-of select="//fnplm:item[@category='ACTIVATION_EXPIRE_THRESHOLD' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="activationExpireThresholdValue">
      <xsl:value-of select="//fnplm:item[@category='ACTIVATION_EXPIRE_THRESHOLD' and @name='threshold']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentLimitDisplay">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_LIMIT' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentThresholdDisplay">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_THRESHOLD' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentThresholdValue">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_THRESHOLD' and @name='threshold']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentExpireThresholdDisplay">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_EXPIRE_THRESHOLD' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentExpireThresholdValue">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_EXPIRE_THRESHOLD' and @name='threshold']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentVersionExpireDisplay">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_VERSION_EXPIRE' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentVersionExpireValue">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_VERSION_EXPIRE' and @name='threshold']/@value"/>
    </xsl:param>
    <xsl:param name="activationExpiredDisplay">
      <xsl:value-of select="//fnplm:item[@category='ACTIVATION_EXPIRED' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentExpiredDisplay">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_EXPIRED' and @name='display']/@value"/>
    </xsl:param>
    <xsl:param name="concurrentVersionExpiredDisplay">
      <xsl:value-of select="//fnplm:item[@category='CONCURRENT_VERSION_EXPIRED' and @name='display']/@value"/>
    </xsl:param>
    
    <form action="/alerts" method="post" name="alertsForm">
      <input type="hidden" name="event"/>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:if test="$compliance508='TRUE'">
        <input type="hidden" name="compliance508" value="TRUE"/>
      </xsl:if>
      <table>
        <tr>
          <td>
            <div class="Container840">
              <div class="ContainerUnderline"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="largerText"><xsl:value-of select="extensions:getString('IDS_CRITICAL_HEADER')" disable-output-escaping="yes"/></div>
              <div class="ContainerUnderline"></div>
            </div>	
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="VENDOR_DAEMON_DOWN.display" value="true" <xsl:if test="$vendorDownDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_DOWN_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_DOWN_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="VENDOR_DAEMON_COULD_NOT_START.display" value="true" <xsl:if test="$vendorCouldNotStartDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_COULD_NOT_START_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_VENDOR_DAEMON_COULD_NOT_START_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="ACTIVATION_LIMIT.display" value="true" <xsl:if test="$limitDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_OUT_OF_ACTIVATABLE_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_OUT_OF_ACTIVATABLE_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="OVERDRAFT_LIMIT.display" value="true" <xsl:if test="$overdraftLimitDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_OUT_OF_OVERDRAFT_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_OUT_OF_OVERDRAFT_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="ACTIVATION_EXPIRED.display" value="true" <xsl:if test="$activationExpiredDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_ACTIVATION_EXPIRED_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_ACTIVATION_EXPIRED_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="CONCURRENT_LIMIT.display" value="true" <xsl:if test="$concurrentLimitDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_OUT_OF_CONCURRENT_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_OUT_OF_CONCURRENT_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="CONCURRENT_EXPIRED.display" value="true" <xsl:if test="$concurrentExpiredDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_CONCURRENT_EXPIRED_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_CONCURRENT_EXPIRED_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="CONCURRENT_VERSION_EXPIRED.display" value="true" <xsl:if test="$concurrentVersionExpiredDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_CONCURRENT_VERSION_EXPIRED_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_CONCURRENT_VERSION_EXPIRED_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <div class="ContainerUnderline"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="largerText"><xsl:value-of select="extensions:getString('IDS_IMPORTANT_HEADER')" disable-output-escaping="yes"/></div>
              <div class="ContainerUnderline"></div>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="ACTIVATION_THRESHOLD.display" value="true" <xsl:if test="$thresholdDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_ACTIVATABLE_THRESHOLD_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="3" name="ACTIVATION_THRESHOLD.threshold" value="<xsl:value-of select="$thresholdValue"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_ACTIVATABLE_THRESHOLD_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="OVERDRAFT.display" value="true" <xsl:if test="$overdraftDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_OVERDRAFT_ISSUED_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:value-of select="extensions:getString('IDS_OVERDRAFT_ISSUED_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="ACTIVATION_EXPIRE_THRESHOLD.display" value="true" <xsl:if test="$activationExpireThresholdDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_ACTIVATION_EXPIRE_THRESHOLD_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="3" name="ACTIVATION_EXPIRE_THRESHOLD.threshold" value="<xsl:value-of select="$activationExpireThresholdValue"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_ACTIVATION_EXPIRE_THRESHOLD_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
             <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="CONCURRENT_THRESHOLD.display" value="true" <xsl:if test="$concurrentThresholdDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_CONCURRENT_THRESHOLD_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="3" name="CONCURRENT_THRESHOLD.threshold" value="<xsl:value-of select="$concurrentThresholdValue"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CONCURRENT_THRESHOLD_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
             <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="CONCURRENT_EXPIRE_THRESHOLD.display" value="true" <xsl:if test="$concurrentExpireThresholdDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_CONCURRENT_EXPIRE_THRESHOLD_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="3" name="CONCURRENT_EXPIRE_THRESHOLD.threshold" value="<xsl:value-of select="$concurrentExpireThresholdValue"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CONCURRENT_EXPIRE_THRESHOLD_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
             <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <div class="Column20Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="checkbox" name="CONCURRENT_VERSION_EXPIRE.display" value="true" <xsl:if test="$concurrentVersionExpireDisplay='true'">checked </xsl:if>/<xsl:text disable-output-escaping="yes">&gt;</xsl:text></div>
              <div class="Column10PercentCentered"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
              <div class="Column59Percent"><strong><xsl:value-of select="extensions:getString('IDS_CONCURRENT_VERSION_EXPIRE_TITLE')" disable-output-escaping="yes"/></strong><br/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="3" name="CONCURRENT_VERSION_EXPIRE.threshold" value="<xsl:value-of select="$concurrentVersionExpireValue"/>" class="textField" maxlength="3" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_CONCURRENT_VERSION_EXPIRE_DESCRIPTION')" disable-output-escaping="yes"/></div>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <div class="Container840">
              <p></p>
            </div>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('alertsForm')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <div id="buttons" style="float: right;">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Save" value="<xsl:value-of select="extensions:getString('IDS_SAVE_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" onClick="return submitAlertConfigForm('save')"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'"  onClick="return submitAlertConfigForm('cancel')"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </div>
          </td>
        </tr>
      </table>
    </form>
  </xsl:template>
</xsl:stylesheet>

