<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:template match="/" name="adminSystem">
    <xsl:if test="$message!='IDS_SHUTDOWN_MESSAGE'">
      <h1><xsl:value-of select="extensions:getString('IDS_SERVER_CONFIGURATION_HEADER')" disable-output-escaping="yes"/></h1>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="$message='SAVE_OK_WARNING'">
        <p>
          <font color="#FF0000">
            <b>
              <xsl:value-of select="extensions:getString('IDS_SAVE_SUCCESSFUL_WARNING')" disable-output-escaping="yes"/>
            </b>
          </font>
        </p>
        <font color="#6CBE06">
          <b>
            <xsl:value-of select="extensions:getString('IDS_SAVE_SUCCESSFUL')" disable-output-escaping="yes"/>
          </b>
        </font>
      </xsl:when>
      <xsl:when test="$message='SAVE_OK'">
        <font color="#6CBE06"><b>
          <xsl:value-of select="extensions:getString('IDS_SAVE_SUCCESSFUL')" disable-output-escaping="yes"/>
        </b></font>
      </xsl:when>
      <xsl:when test="$message='NO_MESSAGE'">
      </xsl:when>
      <xsl:when test="$message='IDS_SHUTDOWN_MESSAGE'">
        <font color="#CC0000"><b><xsl:value-of select="extensions:getString('IDS_SHUTDOWN_MESSAGE')" disable-output-escaping="yes"/></b></font>
      </xsl:when>
      <xsl:when test="$message!=''">
        <font color="#CC0000"><b>
          <xsl:copy-of select="$message" />
        </b></font>
      </xsl:when>
    </xsl:choose>

    <xsl:if test="($EventAction='Save') and (($isHttpsEnabled!=$wasHttpsEnabled) or ($wasHttpsRedirect!=$isHttpsRedirect))">
      <br />
      <font color="#a0a010">
        <xsl:value-of select="extensions:getString('IDS_HTTPS_RESTART_REQUIRED')" disable-output-escaping="yes"/>
      </font>
    </xsl:if>
    
    <xsl:variable name="licenseServerConfigReturn">
      <xsl:value-of select="extensions:getSystemConfiguration('xslt/adminSystemForm.xsl')" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="starts-with($licenseServerConfigReturn, 'ERROR_EXPIRED_SESSION:')">
        <xsl:call-template name="sessionTimeout"/>
      </xsl:when>
      <xsl:when test="$message='IDS_SHUTDOWN_MESSAGE'"></xsl:when>
      <xsl:when test="$licenseServerConfigReturn != ''">
        <xsl:copy-of select="$licenseServerConfigReturn"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="$licenseServerConfigReturn"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
