<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">

    
  <xsl:variable name="systemConfigReturn">
    <xsl:value-of select="extensions:getSystemConfiguration('xslt/adminSystemInfoDisplay.xsl')" disable-output-escaping="yes" />
  </xsl:variable>
  <xsl:variable name="redundantConfigReturn">
    <xsl:value-of select="extensions:getRedundantConfig('xslt/adminRedundantSystemInfoDisplay.xsl')" disable-output-escaping="yes" />
  </xsl:variable>
    
  <xsl:template match="/" name="adminSystemInfo">
    <xsl:value-of select="extensions:getStartupMessages('xslt/startupMessages.xsl')" disable-output-escaping="yes" />
    <h1><xsl:value-of select="extensions:getString('IDS_SYSTEM_INFORMATION_HEADER')" disable-output-escaping="yes"/></h1>
    <xsl:choose>
      <xsl:when test="starts-with($redundantConfigReturn, 'ERROR_EXPIRED_SESSION:') or starts-with($systemConfigReturn, 'ERROR_EXPIRED_SESSION:')">
        <xsl:call-template name="sessionTimeout"/>
      </xsl:when>
      <xsl:when test="starts-with($redundantConfigReturn, 'ERROR_NOT_REDUNDANT_CONFIG:') and $systemConfigReturn != ''">
        <xsl:copy-of select="$systemConfigReturn"/>
      </xsl:when>
      <xsl:when test="$redundantConfigReturn != '' and $systemConfigReturn != ''">
        <xsl:copy-of select="$systemConfigReturn"/><br/><br/>
        <xsl:copy-of select="$redundantConfigReturn"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="$systemConfigReturn"/><br/><br/>
        <xsl:copy-of select="$redundantConfigReturn"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
