<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="vendor"><xsl:value-of select="//fnplm:input/@vendor" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="licenseTab"><xsl:value-of select="//fnplm:input/@licenseTab" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="selected"><xsl:value-of select="//fnplm:input/@selected" disable-output-escaping="yes" /></xsl:param>
  
  <xsl:template match="/" name="signin">
    <xsl:param name="fromChangePassLoc" select="'false'"/>
    <html>
      <head>
        <xsl:choose>
          <xsl:when test="$compliance508!='TRUE'">
            <link rel="stylesheet" type="text/css" href="resources/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/veneerPopup.css"/>
          </xsl:when>
          <xsl:otherwise>
            <link rel="stylesheet" type="text/css" href="resources/508/content.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/structure.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneer.css"/>
            <link rel="stylesheet" type="text/css" href="resources/508/veneerPopup.css"/>
          </xsl:otherwise>
        </xsl:choose>
        <script type="text/javascript" src="resources/ajax.js"/>
        <script type="text/javascript" src="resources/popup.js"/>
        <script type="text/javascript" src="resources/drag.js"/>
        <script type="text/javascript" src="resources/standard.js"/>
      
        <meta http-equiv="Cache-Control" content="no-cache"/>
        <meta http-equiv="Pragma" content="no-cache"/>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
      </head>

      <body id="loginBorder" SCROLL="NO">
        <xsl:choose>
          <xsl:when test="$test=''">
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>form action="/handlesignin" method="post" target="_parent" name="signin" autocomplete="off"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>form action="/handlesignin?test=true" method="post" autocomplete="off"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="checksum" value="<xsl:value-of select="extensions:setChecksum('signin')"/>" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="vendor" value="<xsl:value-of select="$vendor"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="licenseTab" value="<xsl:value-of select="$licenseTab"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="selected" value="<xsl:value-of select="$selected"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="fromChangePassLoc" value="<xsl:value-of select="$fromChangePassLoc"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:if test="$compliance508='TRUE'">
          <input type="hidden" name="compliance508" value="TRUE"/>
        </xsl:if>
        <table width="320"><tr><td>
          <div class="contentSpacer">
            <xsl:choose>
                <xsl:when test="$fromChangePassLoc!='' and $fromChangePassLoc!='false'">
                  <h1><xsl:value-of select="extensions:getString('IDS_RE_SIGN_IN_HEADER')" disable-output-escaping="yes"/></h1>
                </xsl:when>
                <xsl:otherwise>
                  <h1><xsl:value-of select="extensions:getString('IDS_SIGN_IN_HEADER')" disable-output-escaping="yes"/></h1>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:choose>
                <xsl:when test="$failed='NOTAUTHENTICATE'">
                  <xsl:value-of select="extensions:getString('IDS_LOGIN_FAILED')" disable-output-escaping="yes"/><br />
                </xsl:when>
                <xsl:when test="$failed='EXPIRED'">
                  <xsl:value-of select="extensions:getString('IDS_LOGIN_FAILED_WAIT_FOR_EXPIRE')" disable-output-escaping="yes"/><br />
                </xsl:when>
                <xsl:when test="$failed='2ATTEMPTLEFT'">
                  <xsl:value-of select="extensions:getString('IDS_LOGIN_FAILED_TWO_ATTEMP_LEFT')" disable-output-escaping="yes"/><br />
                </xsl:when>
                <xsl:when test="$failed='LASTATTEMPTLEFT'">
                  <xsl:value-of select="extensions:getString('IDS_LOGIN_FAILED_LAST_ATTEMP_LEFT')" disable-output-escaping="yes"/><br />
                </xsl:when>
                <xsl:when test="$failed='permission'">
                  <xsl:value-of select="extensions:getString('IDS_USER_DOES_NOT_HAVE_PERMISSION')" disable-output-escaping="yes"/><br />
                </xsl:when>
                <xsl:when test="$failed='sessiontimeout'">
                  <xsl:value-of select="extensions:getString('IDS_SESSION_TIMEOUT_MESSAGE')" disable-output-escaping="yes"/><br />
                </xsl:when>
              </xsl:choose>
            <xsl:value-of select="extensions:getString('IDS_USER_NAME')" disable-output-escaping="yes"/><br/>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="25" alt="<xsl:value-of select="extensions:getString('IDS_ALT_USER_NAME')" disable-output-escaping="yes"/>" name="username"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <p></p>
            <xsl:value-of select="extensions:getString('IDS_PASSWORD')" disable-output-escaping="yes"/><br/>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="password" size="25" name="password" alt="<xsl:value-of select="extensions:getString('IDS_ALT_PASSWORD')" disable-output-escaping="yes"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <p></p>
            <xsl:if test="$admin='true'">
              <input type="hidden" name="admin" value="true"/>
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="location" value="<xsl:value-of select="$location"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:if>
              
            <xsl:value-of select="extensions:getLocaleList('xslt/localeSelectionDropDown.xsl')" disable-output-escaping="yes" />
              
            <!--a href="password.htm" style="color: #ccc;"><xsl:value-of select="extensions:getString('IDS_FORGOT_PASSWORD')" disable-output-escaping="yes"/></a-->
            <p></p>
            <xsl:if test="$compliance508!='TRUE'">
              <input type="checkbox" name="remember" value="TRUE"/><xsl:value-of select="extensions:getString('IDS_REMEMBER')" disable-output-escaping="yes"/>
              <p></p>
            </xsl:if>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Submit" value="<xsl:value-of select="extensions:getString('IDS_SUBMIT')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:if test="$admin='true'">
              <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="submit" name="Cancel" value="<xsl:value-of select="extensions:getString('IDS_CANCEL_LABEL')" disable-output-escaping="yes"/>" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            </xsl:if>
            <div id="buttons" style="float: right;">
            </div>
          </div>
        </td></tr></table>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/form<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <script type="text/javascript">
          var userLocale = readCookie('userLocale');
          var defaultLocale = "<xsl:value-of select="extensions:getPreference('defaultLocale')"/>";
          if (userLocale != null &amp;&amp; userLocale != "null") {
            defaultLocale = userLocale;
          }
          
          if (defaultLocale != "") {
			if ("options" in document.signin.userlocale)  {
			  for (i = 0; i &lt; document.signin.userlocale.options.length; i++) {
			    if (defaultLocale == document.signin.userlocale.options[i].value) {
			      document.signin.userlocale.options[i].selected = true;
			    }
			  }
			}
          }
          
          var userName = readCookie('userName');
          
          if (userName != null &amp;&amp; userName != "null") {
            document.signin.username.value = userName;
            document.signin.password.focus();
          } else {
            document.signin.username.focus();
          }
        </script>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>

