<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:param name="pageOffset"><xsl:value-of select="//fnplm:input/@pageOffset"/></xsl:param>
  <xsl:param name="pageSize"><xsl:value-of select="//fnplm:input/@pageSize"/></xsl:param>
  <xsl:param name="pages"><xsl:value-of select="ceiling(//fnplm:input/@totalRecords div $pageSize)"/></xsl:param>
  <xsl:param name="firstPageOffset">
    <xsl:choose>
      <xsl:when test="$pageOffset + 3 &gt; $pages">
        <xsl:choose>
          <xsl:when test="$pages - 5 &lt; 0">0</xsl:when>
          <xsl:otherwise><xsl:value-of select="$pages - 5"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$pageOffset - 2 > 0"><xsl:value-of select="$pageOffset - 2"/></xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
  </xsl:param>
  <xsl:param name="search"><xsl:value-of select="//fnplm:input/@search"/></xsl:param>
  <xsl:param name="sortAttr"><xsl:value-of select="//fnplm:input/@sortAttr"/></xsl:param>
  <xsl:param name="sortDir"><xsl:value-of select="//fnplm:input/@sortDir"/></xsl:param>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  
  <xsl:template match="/" name="hosts">
    <xsl:apply-templates select="xml/fnplm:hosts" />
  </xsl:template>
  
  <xsl:template match="fnplm:hosts">
    <div class="largerText"><xsl:value-of select="extensions:getString('IDS_FEATURE_NAME_VERSION_LABEL')" disable-output-escaping="yes"/><br />
      <xsl:value-of select="./@friendlyfeaturename" /><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="./@versionname" />
    </div>
    
    <p></p>
    <div id="searchBox">
      <div id="searchBoxContent">
        <div class="largerText">
          <form action="/concurrenthosts"><xsl:value-of select="extensions:getString('IDS_SEARCH_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="text" size="15" id="session" name="searchCriteria" value="<xsl:value-of select="$search"/>" class="textField" /<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="vendor" value="<xsl:value-of select="./@vendorname" />"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="feature" value="<xsl:value-of select="./@featurename" />"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="version" value="<xsl:value-of select="./@versionname" />"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="compliance508" value="<xsl:value-of select="$compliance508" />"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
            <input type="submit" name="search" value="Search" class="button" onmouseover="this.className='button buttonHover'" onmouseout="this.className='button'"/>
          </form>
        </div>
        <div class="Column30Percent"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></div>
        <div class="Column59Percent">
          <xsl:value-of select="extensions:getString('IDS_PAGE')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><strong><xsl:value-of select="$pageOffset + 1"/></strong><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="extensions:getString('IDS_OF')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="$pages"/><br />
          <xsl:if test="$pages>1">
            <nobr>
              <xsl:choose>
                <xsl:when test="$pageOffset!=0">
                  <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$pageOffset - 1"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>&lt;<xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
                </xsl:when>
                <xsl:otherwise><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>&lt;<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></xsl:otherwise>
              </xsl:choose>
                <xsl:if test="$firstPageOffset!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$firstPageOffset"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:if test="$firstPageOffset=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:value-of select="$firstPageOffset + 1"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$firstPageOffset!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
            <xsl:if test="$firstPageOffset + 1 &lt; $pages">
              | <xsl:if test="$firstPageOffset+1!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$firstPageOffset + 1"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:if test="$firstPageOffset+1=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:value-of select="$firstPageOffset + 2"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$firstPageOffset+1!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
            </xsl:if>
            <xsl:if test="$firstPageOffset + 2 &lt; $pages">
              | <xsl:if test="$firstPageOffset+2!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$firstPageOffset + 2"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:if test="$firstPageOffset+2=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:value-of select="$firstPageOffset + 3"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$firstPageOffset+2!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
            </xsl:if>
            <xsl:if test="$firstPageOffset + 3 &lt; $pages">
              | <xsl:if test="$firstPageOffset+3!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$firstPageOffset + 3"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:if test="$firstPageOffset+3=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:value-of select="$firstPageOffset + 4"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$firstPageOffset+3!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
            </xsl:if>
            <xsl:if test="$firstPageOffset + 4 &lt; $pages">
              | <xsl:if test="$firstPageOffset+4!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$firstPageOffset + 4"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:if test="$firstPageOffset+4=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if><xsl:value-of select="$firstPageOffset + 5"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/strong<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:if test="$firstPageOffset+4!=$pageOffset"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="$pageOffset + 1!=$pages">
                <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="./@vendorname" />&amp;feature=<xsl:value-of select="./@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>&amp;pageOffset=<xsl:value-of select="$pageOffset + 1"/>&amp;sortAttr=<xsl:value-of select="$sortAttr"/>&amp;sortDir=<xsl:value-of select="$sortDir"/>&amp;search=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>&gt;<xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
              </xsl:when>
              <xsl:otherwise><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>&gt;<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></xsl:otherwise>
            </xsl:choose>
            </nobr>
          </xsl:if>
        </div>
      </div>
    </div>
    <script language="javascript">
    function sortTableLocal(element) {
      var url = "/concurrenthosts?vendor=<xsl:value-of select="./@vendorname"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>feature=<xsl:value-of select="./@featurename"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>version=<xsl:value-of select="./@versionname"/><xsl:text disable-output-escaping="yes">&amp;</xsl:text>searchCriteria=<xsl:value-of select="$search"/><xsl:if test="$compliance508='TRUE'">
        <xsl:text disable-output-escaping="yes">&amp;</xsl:text>compliance508=TRUE</xsl:if>";
      if (element.getAttribute("name") == "host") {
        url += "<xsl:text disable-output-escaping="yes">&amp;</xsl:text>sortAttr=hostname";
      } else if (element.getAttribute("name") == "user") {
        url += "<xsl:text disable-output-escaping="yes">&amp;</xsl:text>sortAttr=username";
      } else if (element.getAttribute("name") == "display") {
        url += "<xsl:text disable-output-escaping="yes">&amp;</xsl:text>sortAttr=displayname";
      } else if (element.getAttribute("name") == "count") {
        url += "<xsl:text disable-output-escaping="yes">&amp;</xsl:text>sortAttr=count";
      }
      
      if (element.getAttribute("direction") == "ascending") {
        url += "<xsl:text disable-output-escaping="yes">&amp;</xsl:text>sortDir=descending";
      } else {
        url += "<xsl:text disable-output-escaping="yes">&amp;</xsl:text>sortDir=ascending";
      }
      
      document.location.href = url;
    }
    </script>
    <p></p>
    <div class="widgetTableDiv">
      <table id="myTable">
        <thead>
          <tr>
            <td style="visibility:hidden"></td>
            <td name="host"><xsl:value-of select="extensions:getString('IDS_HOST_HEADING')" disable-output-escaping="yes"/></td>
            <td name="user"><xsl:value-of select="extensions:getString('IDS_USER_HEADING')" disable-output-escaping="yes"/></td>
            <td name="display"><xsl:value-of select="extensions:getString('IDS_DISPLAY_HEADING')" disable-output-escaping="yes"/></td>
            <td name="count"><xsl:value-of select="extensions:getString('IDS_COUNT_HEADING')" disable-output-escaping="yes"/></td>
          </tr>
        </thead>
        <tbody class="scrollingContent">
          <xsl:apply-templates select="fnplm:host" />
        </tbody>
      </table>
    </div>
    <p></p>
  </xsl:template>
  
  <xsl:template match="fnplm:host">
    <tr onClick="">
      <td style="visibility:hidden"></td>
      <td><xsl:value-of select="./@hostname"/></td>
      <td><xsl:value-of select="./@username"/></td>
      <td><xsl:value-of select="./@displayname"/></td>
      <td><xsl:value-of select="./@count"/></td>
    </tr>
  </xsl:template>
</xsl:stylesheet>


