<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:include href="commonDashboard.xsl"/>
  <xsl:include href="sessionTimeout.xsl"/>

  <xsl:param name="tempHostName">
    <xsl:value-of select="extensions:getHostIdentification('xslt/getHostName.xsl')" disable-output-escaping="yes" />
  </xsl:param>
  <xsl:param name="hostName">
    <xsl:value-of select="translate( $tempHostName, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
  </xsl:param>

  <xsl:param name="tempHostNameWithDomain">
    <xsl:value-of select="extensions:getHostIdentification('xslt/getHostNameWithDomain.xsl')" disable-output-escaping="yes" />
  </xsl:param>
  <xsl:param name="hostNameWithDomain">
    <xsl:value-of select="translate( $tempHostNameWithDomain, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
  </xsl:param> 
  
  <xsl:param name="hostIPv4Address">
    <xsl:value-of select="extensions:getHostIdentification('xslt/getHostIPv4Address.xsl')" disable-output-escaping="yes" />
  </xsl:param>
  
  <xsl:param name="hostIPv6Address">
    <xsl:value-of select="extensions:getHostIdentification('xslt/getHostIPv6Address.xsl')" disable-output-escaping="yes" />
  </xsl:param>
  
<xsl:param name="tempMasterName">
  <xsl:value-of select="extensions:getRedundantConfig('xslt/getMasterName.xsl')" disable-output-escaping="yes" />
</xsl:param>
  <xsl:param name="masterName">
    <xsl:choose>
      <xsl:when test="starts-with($tempMasterName, 'ERROR_NOT_REDUNDANT_CONFIG:')"></xsl:when>
      <xsl:otherwise><xsl:value-of select="translate($tempMasterName, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:param name="isMaster">
    <xsl:choose>
      <xsl:when test="$masterName='' or contains($hostName, $masterName) or contains($hostIPv4Address, $masterName) or contains($hostIPv6Address, $masterName) or contains($hostNameWithDomain, $masterName)">TRUE</xsl:when> 
      <xsl:otherwise>FALSE</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:param name="login" select="'FALSE'"/>
  <xsl:variable name="visibleLicenseValue">
    <xsl:variable name="getPreferenceReturn">
      <xsl:value-of select="extensions:getPreference('visibleLicense')" disable-output-escaping="yes" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$getPreferenceReturn='' or substring-after($getPreferenceReturn, ':')!=''">3</xsl:when>
      <xsl:otherwise><xsl:value-of select="$getPreferenceReturn"/></xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:param name="licenseTab">
    <xsl:choose>
      <xsl:when test="$visibleLicenseValue=1"></xsl:when>
      <xsl:when test="$visibleLicenseValue=2">floating</xsl:when>
      <xsl:otherwise><xsl:value-of select="//fnplm:input/@licenseTab" /></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="selectedVendor">
    <xsl:choose>
      <xsl:when test="//fnplm:input/@vendor!=''"><xsl:value-of select="extensions:getVendorList(//fnplm:input/@vendor, 'xslt/testVendorParameter.xsl')" disable-output-escaping="yes" /></xsl:when>
      <xsl:otherwise><xsl:value-of select="extensions:getVendorList('', 'xslt/vendorByIndex.xsl')" disable-output-escaping="yes" /></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="compliance508"><xsl:value-of select="//fnplm:input/@compliance508"/></xsl:param>
  <xsl:variable name="dashboardEvent"><xsl:value-of select="//fnplm:input/@event" /></xsl:variable>
  <xsl:variable name="id"><xsl:value-of select="//fnplm:input/@id" /></xsl:variable>
  <xsl:variable name="adminTabInput"><xsl:value-of select="//fnplm:input/@admin"/></xsl:variable>
  <xsl:param name="admin">
    <xsl:choose>
      <xsl:when test="$adminTabInput='users'">USERS</xsl:when>
      <xsl:when test="$adminTabInput='alerts'">ALERTS</xsl:when>
      <xsl:when test="$adminTabInput='vendor'">VENDOR</xsl:when>
      <xsl:when test="$adminTabInput='systeminfo'">SYSTEMINFO</xsl:when>
      <xsl:otherwise>admin</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:variable name="protectDashboard">
    <xsl:value-of select="extensions:getPreference('protectDashboard')" disable-output-escaping="yes"/>
  </xsl:variable>
  
  <xsl:param name="eventResult">
    <xsl:choose>
      <xsl:when test="$dashboardEvent!=''">
        <xsl:value-of select="extensions:dismissAlert($id)"/>
      </xsl:when>
    </xsl:choose>
  </xsl:param>
    
  <xsl:param name="message">
    <xsl:choose>
      <xsl:when test="starts-with($eventResult, 'ERROR_UNAUTHORIZED_ACCESS:')">
        <xsl:value-of select="substring($eventResult, 27)" />
      </xsl:when>
      <xsl:when test="$eventResult='Save'">SAVE_OK</xsl:when>
      <xsl:otherwise>NO_MESSAGE</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/" name="login">
    <xsl:if test="starts-with($eventResult, 'ERROR_EXPIRED_SESSION:')">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    <xsl:call-template name="dashboard"/>
  </xsl:template>
</xsl:stylesheet>

