<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  
  <xsl:template match="/" name="licenseItem">
     <xsl:apply-templates select="xml/fnplm:features" />
  </xsl:template>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  
  <xsl:template match="fnplm:features">
    <xsl:apply-templates select="fnplm:feature" />
  </xsl:template>
  
  <xsl:template match="fnplm:feature">
    <xsl:variable name="featureName" select="./@featurename"/>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onClick="showSection('<xsl:value-of select="./@featurename"/>');"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <table cellspacing="0" width="585">
      <tr>
        <td header="header1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>img src="images/icons/14tableOpen.gif" name="img<xsl:value-of select="./@featurename"/>" width="14" height="14" border="0" align="left"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="./@friendlyfeaturename"/></td>
      </tr>
    </table>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div id="<xsl:value-of select="./@featurename"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <table cellspacing="0" width="585" class="licenseContainer">
      <xsl:apply-templates select="fnplm:version"/>
    </table>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <table cellspacing="0" width="585">
      <tr><td class="tableRow"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td></tr>
    </table>
  </xsl:template>
  
  <xsl:template match="fnplm:version">
    <xsl:variable name="versionName" select="./@versionname"/>
 
    <tr>
      <td class="licenseContainer">
        <table cellspacing="0" width="585">
          <tr>
            <td width="25%"></td>
            <td width="12%" header="header2"><xsl:value-of select="extensions:getString($versionName)" disable-output-escaping="yes"/></td>
            <td width="15%" class="center" header="header3"	><xsl:value-of select="./@count"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
              <xsl:choose>
                <xsl:when test="./@maxallowedcount&lt;1">(<xsl:value-of select="extensions:getString('IDS_UNCOUNTED')" disable-output-escaping="yes"/>)</xsl:when>
                <xsl:otherwise>(<xsl:value-of select="./@maxallowedcount"/>)</xsl:otherwise>
              </xsl:choose>
            </td>
            <td width="9%" class="center" header="header4"></td>
            <td width="21%" class="center">
              <xsl:choose>
                <xsl:when test="./@expiration='IDS_PERMANENT'"><xsl:value-of select="extensions:getString('IDS_PERMANENT')" disable-output-escaping="yes"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="extensions:getNumberedDate(./@expiration)"/></xsl:otherwise>
              </xsl:choose>
            </td>
            <td width="9%" class="center">
              <xsl:if test="./@count > 0">
                <xsl:choose>
                  <xsl:when test="$compliance508!='TRUE'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onclick="javascript:NewWindow('concurrenthosts?vendor=<xsl:value-of select="../../@vendorname"/>&amp;feature=<xsl:value-of select="../@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_HOSTS_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/concurrenthosts?vendor=<xsl:value-of select="../../@vendorname"/>&amp;feature=<xsl:value-of select="../@featurename"/>&amp;version=<xsl:value-of select="./@versionname"/>" class="textLink" target="_blank"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_HOSTS_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </td>
            <td width="9%" class="center">
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>
  
</xsl:stylesheet>
