<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:include href="vendorSelectionForm.xsl"/>
  <xsl:param name="selected"><xsl:value-of select="//fnplm:input/@selected" disable-output-escaping="yes" /></xsl:param>
  <xsl:variable name="isexpiredPassword">
    <xsl:value-of select="extensions:getUserList('xslt/expiredPassword.xsl')" disable-output-escaping="yes" />
  </xsl:variable>

  <xsl:template name="licenseSummary">
    <div class="contentSpacer">
      <h1>
        <xsl:choose>
          <xsl:when test="$visibleLicenseValue=1"><xsl:value-of select="extensions:getString('IDS_NODE_LOCKED_LICENSE_HEADER')" disable-output-escaping="yes"/></xsl:when>
          <xsl:when test="$visibleLicenseValue=2"><xsl:value-of select="extensions:getString('IDS_FLOATING_LICENSE_HEADER')" disable-output-escaping="yes"/></xsl:when>
          <xsl:otherwise><xsl:value-of select="extensions:getString('IDS_LICENSE_HEADER')" disable-output-escaping="yes"/></xsl:otherwise>
        </xsl:choose>
      </h1>
      <p></p>
      <xsl:variable name="vendorDropReturn">
        <xsl:call-template name="vendorSelectionForm"/>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="starts-with($vendorDropReturn, 'ERROR_EXPIRED_SESSION:')">
          <xsl:call-template name="sessionTimeout"/>
        </xsl:when>
        <xsl:when test="$vendorDropReturn != ''">
          <div id="vendorSelector"><xsl:copy-of select="$vendorDropReturn"/></div>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$vendorDropReturn"/>
        </xsl:otherwise>
      </xsl:choose>
    
      <xsl:if test="$visibleLicenseValue=3">
        <div class="columnBlockClick">
          <xsl:if test="$visibleLicenseValue=1 or $visibleLicenseValue=3">
            <xsl:choose>
              <xsl:when test="$licenseTab!='floating'">
                <div class="columnBlockButton">
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?vendor=<xsl:value-of select="$selectedVendor"/>&amp;admin=<xsl:value-of select="$adminTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/60activatableIn.gif" name="nodeLocked"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  <div class="largerTextSelected"><strong><xsl:value-of select="extensions:getString('IDS_NODE_LOCKED_HEADER')" disable-output-escaping="yes"/></strong></div>
                </div>
              </xsl:when>
              <xsl:otherwise>
                <div class="columnBlockButton">
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?vendor=<xsl:value-of select="$selectedVendor"/>&amp;admin=<xsl:value-of select="$adminTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" onmouseover="rollover('floating','images/icons/60activatableOutOver.gif');" onmouseout="rollover('floating','images/icons/60activatableOutOver.gif');"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/60activatableOutOver.gif" name="floating"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  <div class="largerText"><strong><xsl:value-of select="extensions:getString('IDS_NODE_LOCKED_HEADER')" disable-output-escaping="yes"/></strong></div>
                </div>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
          <xsl:if test="$visibleLicenseValue=2 or $visibleLicenseValue=3">
            <xsl:choose>
              <xsl:when test="$licenseTab!='floating'">
                <div class="columnBlockButton">
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?licenseTab=floating&amp;vendor=<xsl:value-of select="$selectedVendor"/>&amp;admin=<xsl:value-of select="$adminTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" onmouseover="rollover('floating','images/icons/60concurrentOutOver.gif');" onmouseout="rollover('floating','images/icons/60concurrentOutOver.gif');"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/60concurrentOutOver.gif" name="floating"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  <div class="largerText"><strong><xsl:value-of select="extensions:getString('IDS_FLOATING_HEADER')" disable-output-escaping="yes"/></strong></div>
                </div>
              </xsl:when>
              <xsl:otherwise>
                <div class="columnBlockButton">
                  <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="dashboard?licenseTab=floating&amp;vendor=<xsl:value-of select="$selectedVendor"/>&amp;admin=<xsl:value-of select="$adminTab"/>&amp;selected=<xsl:value-of select="$selected"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><img src="images/icons/60concurrentIn.gif" name="nodeLocked"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  <div class="largerTextSelected"><strong><xsl:value-of select="extensions:getString('IDS_FLOATING_HEADER')" disable-output-escaping="yes"/></strong></div>
                </div>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
        </div>
      </xsl:if>
      <p></p>
      <div class="tableHeaderTitle">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>table cellspacing="0" summary="<xsl:value-of select="extensions:getString('IDS_LICENSE_TABLE_DESCRIPTION')" disable-output-escaping="yes"/>" width="595"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
          <tr>
            <td>
              <table cellspacing="0" width="100%">
                <tr>
                  <th width="10%" ><div align="left">
                    <xsl:choose>
                      <xsl:when test="$licenseTab!='floating'">
                        <xsl:value-of select="extensions:getString('IDS_PRODUCT_HEADER')" disable-output-escaping="yes"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="extensions:getString('IDS_FEATURE_HEADER')" disable-output-escaping="yes"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </div></th>
				   <th width="13%" id="header2"><div align="center"><xsl:if test="$licenseTab!='floating'"><xsl:value-of select="extensions:getString('IDS_ENTITLEMENT_HEADER')" disable-output-escaping="yes"/></xsl:if></div></th>
                  <th width="12%" id="header3"><div align="center"><xsl:value-of select="extensions:getString('IDS_VERSION_HEADER')" disable-output-escaping="yes"/></div></th>
				  <th width="18%" id="header4"><div align="center">
                    <xsl:choose>
                      <xsl:when test="$licenseTab!='floating'">
                        <xsl:value-of select="extensions:getString('IDS_PRODUCT_TOTAL_HEADER')" disable-output-escaping="yes"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <xsl:value-of select="extensions:getString('IDS_FEATURE_TOTAL_HEADER')" disable-output-escaping="yes"/>
                      </xsl:otherwise>
                    </xsl:choose>				  
				  </div></th>
                  <th width="12%" id="header5"><div align="center"><xsl:if test="$licenseTab!='floating'"><xsl:value-of select="extensions:getString('IDS_OVERDRAFT_HEADER')" disable-output-escaping="yes"/></xsl:if></div></th>
                  <th width="16%" id="header6"><div align="center"><xsl:value-of select="extensions:getString('IDS_EXPIRATION_HEADER')" disable-output-escaping="yes"/></div></th>
                  <th width="18%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>	</th>
                </tr>
              </table>
            </td>
            <td style="width: 17px;"></td>
          </tr>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/table<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
      </div>
      <xsl:if test="$compliance508!='TRUE'">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div class="scrollerLarge"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </xsl:if>
      <xsl:variable name="summaryReturn">
        <xsl:choose>
          <xsl:when test="$isMaster='FALSE'">
            <span class="warningText"><xsl:value-of select="extensions:getString('IDS_NON_MASTER_HOST')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="$tempMasterName"/></span>
          </xsl:when>
          <xsl:when test="$licenseTab!='floating'">
            <xsl:value-of select="extensions:getProductSummary($selectedVendor, 'xslt/licenseSummaryDetails.xsl')" disable-output-escaping="yes" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="extensions:getFeatureSummary($selectedVendor, 'xslt/floatingSummaryDetails.xsl')" disable-output-escaping="yes" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
        
      <xsl:choose>
        <xsl:when test="$login='TRUE' or $isexpiredPassword='true'">
        </xsl:when>
        <xsl:when test="starts-with($summaryReturn, 'ERROR_EXPIRED_SESSION:')">
          <xsl:call-template name="sessionTimeout"/>
        </xsl:when>
        <xsl:when test="starts-with($summaryReturn, 'ERROR_NOSUCH_FEATURE:')!=''">
          <xsl:value-of select="substring-after($summaryReturn, ':')"/>
        </xsl:when>
        <xsl:when test="starts-with($summaryReturn, 'ERROR_VENDOR_ERROR:')!=''">
          <xsl:value-of select="substring-after($summaryReturn, ':')"/>
          <xsl:variable name="errorMessageCount" select="extensions:getStartupMessages('xslt/errorMessageCount.xsl')"/>
           <xsl:if test="$errorMessageCount > 0">
			   <br/><br/><xsl:value-of select="extensions:getString('IDS_STARTUP_ERRORS')" disable-output-escaping="yes"/>
           </xsl:if>
        </xsl:when>
        <xsl:when test="$summaryReturn != ''">
          <xsl:copy-of select="$summaryReturn"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:copy-of select="$summaryReturn"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="licenseItem"/>
      <xsl:if test="$compliance508!='TRUE'">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </xsl:if>
    </div>

  </xsl:template>
</xsl:stylesheet>
