<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  
  <xsl:template match="/" name="licenseItem">
     <xsl:apply-templates select="xml/fnplm:products" />
  </xsl:template>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  
  <xsl:template match="fnplm:products">
    <xsl:apply-templates select="fnplm:product" />
  </xsl:template>
  
  <xsl:template match="fnplm:product">
    <xsl:variable name="productName" select="./@productname"/>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onClick="showSection('<xsl:value-of select="./@productname"/>');"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <table cellspacing="0" width="585">
      <tr>
        <td header="header1"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>img src="images/icons/14tableOpen.gif" name="img<xsl:value-of select="./@productname"/>" width="14" height="14" border="0" align="left"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString($productName)" disable-output-escaping="yes"/></td>
      </tr>
    </table>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>div id="<xsl:value-of select="./@productname"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <table cellspacing="0" width="585" class="licenseContainer">
      <xsl:apply-templates select="fnplm:version"/>
    </table>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/div<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    <table cellspacing="0" width="585">
      <tr><td class="tableRow"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td></tr>
    </table>
  </xsl:template>
  
  <xsl:template match="fnplm:version">
    <xsl:variable name="name" select="./@name"/>
    <tr>
      <td class="licenseContainer">
        <table style="table-layout:fixed" cellspacing="0" width="585">
          <tr>
            <td width="12%"></td>
			<td style="word-wrap:break-word" width="11%" class="left" header="header2"	><xsl:value-of select="./@entitlementid"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></td>
            <td style="word-wrap:break-word" width="11%" class="center" header="header3"><xsl:value-of select="extensions:getString($name)" disable-output-escaping="yes"/></td>
            <td width="19%" class="center" header="header4"	><xsl:value-of select="./@activated"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>(<xsl:value-of select="./@availableActivations"/>)</td>
            <td width="10%" class="center" header="header5"><xsl:value-of select="./@activatedOverdrafts"/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>(<xsl:value-of select="./@availableActivationOverdrafts"/>)</td>
            <td width="18%" class="center">
              <xsl:value-of select="extensions:getNumberedDate(./@expiration)"/>
            </td>
            <td width="7%" class="center">
              <xsl:if test="./@activated &gt; 0 or ./@activatedOverdrafts &gt; 0">
                <xsl:choose>
                  <xsl:when test="$compliance508!='TRUE'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onclick="javascript:NewWindow('hosts?vendor=<xsl:value-of select="../../@vendorname"/>&amp;productId=<xsl:value-of select="./@entitlementid"/>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_HOSTS_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/hosts?vendor=<xsl:value-of select="../../@vendorname"/>&amp;productId=<xsl:value-of select="./@entitlementid"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" target="_blank" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_HOSTS_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </td>
            <td width="12%" class="center">
              <xsl:if test="./@availableActivations > 0">
                <xsl:choose>
                  <xsl:when test="$compliance508!='TRUE'">
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="#" onclick="javascript:NewWindow('fulfillments?vendor=<xsl:value-of select="../../@vendorname"/>&amp;productId=<xsl:value-of select="./@entitlementid"/>', 'FlexNet', '650','600','yes','yes');" class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_FULFILLMENTS_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/fulfillments?vendor=<xsl:value-of select="../../@vendorname"/>&amp;productId=<xsl:value-of select="./@entitlementid"/><xsl:if test="$compliance508='TRUE'">&amp;compliance508=TRUE</xsl:if>" class="textLink" target="_blank"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_FULFILLMENTS_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:if>
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </xsl:template>
  
</xsl:stylesheet>
