<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
<xsl:output method="html"/>
<xsl:param name="selectedVendor" select="''"/>
  
  <xsl:template match="/" name="localeSelection">
    <xsl:apply-templates select="//fnplm:locales"/>
  </xsl:template>

  <xsl:template match="fnplm:locales">
      <xsl:choose>
        <xsl:when test="count(//fnplm:locale) > 1">
          <select name="defaultLocale">
            <xsl:apply-templates select="fnplm:locale"/>
          </select>
          <p></p>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text disable-output-escaping="yes">&lt;</xsl:text>input type="hidden" name="defaultLocale" value="<xsl:value-of select="//fnplm:locale/@name"/>"/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
  </xsl:template>
  
  <xsl:template match="fnplm:locale">
    <xsl:variable name="localeString">LOCALE_<xsl:value-of select="./@name"/></xsl:variable>
     <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value="<xsl:value-of select="./@name"/>"<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
     <xsl:value-of select="extensions:getString($localeString)" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
</xsl:stylesheet>
