<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:include href="commonSignin.xsl"/>
  <xsl:include href="autoLogin.xsl"/>
  
  <xsl:param name="failed"><xsl:value-of select="//fnplm:input/@failed"/></xsl:param>
  <xsl:param name="test"><xsl:value-of select="//fnplm:input/@test"/></xsl:param>
  <xsl:param name="compliance508" select="'TRUE'"/>
  <xsl:param name="admin"><xsl:value-of select="//fnplm:input/@admin"/></xsl:param>
  <xsl:variable name="protectDashboard">
    <xsl:value-of select="extensions:getPreference('protectDashboard')" disable-output-escaping="yes"/>
  </xsl:variable>
  <xsl:param name="location"><xsl:value-of select="//fnplm:input/@location"/></xsl:param>

  
  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="$protectDashboard='false' and $admin!='true' and $failed=''"><xsl:call-template name="autoLogin"/></xsl:when>
      <xsl:otherwise><xsl:call-template name="signin"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>

