<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
<xsl:output method="html"/>
<xsl:param name="currentLevel" select="//fnplm:configuration/@level"/>
  
  <xsl:template match="/" name="levelSelection">
    <select name="level" class="textField">
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value="ERROR" <xsl:if test="$currentLevel='ERROR'">SELECTED</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_ERROR_LOGGING_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value="INFO" <xsl:if test="$currentLevel='INFO'">SELECTED</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_INFO_LOGGING_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value="WARN" <xsl:if test="$currentLevel='WARN'">SELECTED</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_WARN_LOGGING_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>option value="NONE" <xsl:if test="$currentLevel='NONE'">SELECTED</xsl:if><xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_NONE_LOGGING_LABEL')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/option<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    </select><br/><br/>
  </xsl:template>
</xsl:stylesheet>

