<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  
  <xsl:variable name="messageCount" select="count(//fnplm:message)"/>
  
  <xsl:template match="/">
    <xsl:if test="$messageCount>0">
      <h1>IDS_STARTUP_MESSAGES_HEADER</h1>
      <xsl:apply-templates select="//fnplm:messages"/>
      <br/><br/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="results" match="//fnplm:messages">
    <xsl:if test="//fnplm:message[@type='info']">
      <strong><xsl:value-of select="extensions:getString('IDS_STARTUP_INFO_HEADER')" disable-output-escaping="yes"/></strong>
      <div id="importInfo">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          <xsl:apply-templates select="//fnplm:message[@type='info']"/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </div>
    </xsl:if>
    
    <xsl:if test="//fnplm:message[@type='error']">
      <strong><xsl:value-of select="extensions:getString('IDS_STARTUP_ERROR_HEADER')" disable-output-escaping="yes"/></strong>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
        <xsl:apply-templates select="//fnplm:message[@type='error']"/>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
    </xsl:if>
    
    <xsl:if test="//fnplm:message[@type='warning']">
      <strong><xsl:value-of select="extensions:getString('IDS_STARTUP_WARNING_HEADER')" disable-output-escaping="yes"/></strong>
      <div id="importWarning">
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
          <xsl:apply-templates select="//fnplm:message[@type='warning']"/>
        <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/ul<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      </div>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="error" match="fnplm:message[@type='error']">
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>li<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <b><span class="errorText"><xsl:value-of select="./@message"/></span></b>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/li<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="warning" match="fnplm:message[@type='warning']">
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>li<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <b><span class="warningText"><xsl:value-of select="./@message"/></span></b>
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/li<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
  
  <xsl:template name="info" match="fnplm:message[@type='info']">
    <xsl:text disable-output-escaping="yes">&lt;</xsl:text>li<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <b><span class="infoText"><xsl:value-of select="./@message"/></span></b>
   <xsl:text disable-output-escaping="yes">&lt;</xsl:text>/li<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
  </xsl:template>
</xsl:stylesheet>

