<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html" version="4.01" encoding="UTF-8"/>
  <xsl:include href="commonAdmin.xsl"/>
  <xsl:include href="sessionTimeout.xsl"/>
  <xsl:variable name="help_id">HELP_IDS_VENDOR</xsl:variable>
  <xsl:variable name="vendorEvent">
    <xsl:choose>
      <xsl:when test="//fnplm:input[@name='Cancel']='Cancel'">cancel</xsl:when>
      <xsl:when test="//fnplm:input[@name='event']!=''">
        <xsl:value-of select="//fnplm:input[@name='event']"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="//fnplm:input/@event" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
   <xsl:variable name="vendorchecksum">
    <xsl:choose>
      <xsl:when test="//fnplm:input[@name='checksum']!=''">
        <xsl:value-of select="//fnplm:input[@name='checksum']"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="//fnplm:input/@checksum" />
      </xsl:otherwise>
	</xsl:choose>
   </xsl:variable>
  <xsl:variable name="vendor">
    <xsl:choose>
      <xsl:when test="//fnplm:input[@name='vendor']!=''">
        <xsl:value-of select="//fnplm:input[@name='vendor']" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="//fnplm:input/@vendor" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="rotate"><xsl:value-of select="//fnplm:input[@name='Rotate']"/></xsl:variable>
  <xsl:variable name="reread"><xsl:value-of select="//fnplm:input[@name='Reread']"/></xsl:variable>
  <xsl:variable name="saveConfig"><xsl:value-of select="//fnplm:input[@name='SaveConfig']"/></xsl:variable>
  <xsl:variable name="saveAndReread"><xsl:value-of select="//fnplm:input[@name='SaveAndReread']"/></xsl:variable>
  <xsl:variable name="delete"><xsl:value-of select="//fnplm:input[@name='delete']"/></xsl:variable>
  <xsl:variable name="logName"><xsl:value-of select="//fnplm:input[@name='logName']"/></xsl:variable>
  <xsl:param name="compliance508">
    <xsl:choose>
      <xsl:when test="//fnplm:input[@name='compliance508']!=''">
        <xsl:value-of select="//fnplm:input[@name='compliance508']"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="//fnplm:input/@compliance508"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:variable name="stopDaemon"><xsl:value-of select="//fnplm:input[@name='StopDaemon']"/></xsl:variable>
  <xsl:variable name="startDaemon"><xsl:value-of select="//fnplm:input[@name='StartDaemon']"/></xsl:variable>
  <xsl:variable name="path"><xsl:value-of select="//fnplm:input[@name='path']"/></xsl:variable>
  <xsl:variable name="licenseFile"><xsl:value-of select="//fnplm:input[@name='licenseFile']"/></xsl:variable>
  <xsl:variable name="licenseFilename"><xsl:value-of select="//fnplm:input[@name='licenseFile.filename']"/></xsl:variable>
  <xsl:variable name="overwrite">
    <xsl:choose>
      <xsl:when test="//fnplm:input[@name='overwrite']!=''">
        <xsl:value-of select="//fnplm:input[@name='overwrite']"/>
      </xsl:when>
      <xsl:otherwise>false</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:variable name="license"><xsl:value-of select="//fnplm:input[@name='license']"/></xsl:variable>
  <xsl:variable name="oldLicense"><xsl:value-of select="//fnplm:input[@name='oldLicense']"/></xsl:variable>
  <xsl:variable name="inXML" select="//xml/*"/>


  <xsl:variable name="vendorStatus">
    <xsl:value-of select="extensions:getVendorList($vendor, 'xslt/vendorStatus.xsl')" disable-output-escaping="yes" />
  </xsl:variable>

  <xsl:param name="admin" select="'VENDOR'"/>
  <xsl:param name="eventResult">
    <xsl:choose>
      <xsl:when test="$vendorEvent!='' and $vendorEvent!='edit' and $vendorEvent!='save' and $vendorEvent!='saveandreread' and $vendorEvent!='cancel' and $vendorEvent!='importLicense' and $vendorEvent!='delete' and $vendorEvent!='start' and $vendorEvent!='stop'">
        <xsl:value-of select="extensions:doVendorAction($vendor, $vendorchecksum, $vendorEvent, $logName)" disable-output-escaping="yes" />
      </xsl:when>
      <xsl:when test="($startDaemon!='' or $vendorEvent='start') and $vendorStatus!='RUNNING' and $vendorStatus!='RUNNING_PENDING'">
        <xsl:value-of select="extensions:doVendorAction($vendor, $vendorchecksum, 'start', $logName)" disable-output-escaping="yes" />
      </xsl:when>
      <xsl:when test="($stopDaemon!='' or $vendorEvent='stop') and $vendorStatus!='STOPPED' and $vendorStatus!='STOPPED_PENDING'">
        <xsl:value-of select="extensions:doVendorAction($vendor, $vendorchecksum, 'stop', $logName)" disable-output-escaping="yes" />
      </xsl:when>
      <xsl:when test="$reread!=''">
        <xsl:value-of select="extensions:doVendorAction($vendor, $vendorchecksum, 'reread', $logName)" disable-output-escaping="yes" />
      </xsl:when>
      <xsl:when test="$saveConfig!='' or $vendorEvent='save'">
        <xsl:value-of select="extensions:setVendorConfig($vendor, $inXML)" disable-output-escaping="yes" />
      </xsl:when>
      <xsl:when test="$saveAndReread!='' or $vendorEvent='saveandreread'">
        <xsl:variable name="setVendorReturn">
          <xsl:value-of select="extensions:setVendorConfig($vendor, $inXML)" disable-output-escaping="yes" />
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="$setVendorReturn=''">
            <xsl:value-of select="extensions:doVendorAction($vendor, $vendorchecksum, 'reread', $logName)" disable-output-escaping="yes" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$setVendorReturn"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$delete!='' or $vendorEvent='delete'">
        <xsl:value-of select="extensions:removeVendor($vendor, $vendorchecksum)" disable-output-escaping="yes" />
      </xsl:when>
      <xsl:when test="$rotate!=''">
        <xsl:choose>
          <xsl:when test="$logName!=''">
            <xsl:value-of select="extensions:doVendorAction($vendor, $vendorchecksum, 'rotatelog', $logName)" disable-output-escaping="yes" />
          </xsl:when>
          <xsl:otherwise>IDS_REQUIRES_LOG_FILE</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$vendorEvent='importLicense'">
        <xsl:choose>
          <xsl:when test="$licenseFile!=''">
            <xsl:value-of select="extensions:uploadLicense($licenseFile, $licenseFilename, $overwrite, 'xslt/importLicense.xsl', $vendorchecksum)" disable-output-escaping="yes" />
          </xsl:when>
          <xsl:otherwise>IDS_LICENSE_FILE_EMPTY:<xsl:value-of select="extensions:getString('IDS_LICENSE_FILE_EMPTY')" disable-output-escaping="yes"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="message">
    <xsl:choose>
      <xsl:when test="substring-after($eventResult, ':')!=''">
        <xsl:value-of select="substring-after($eventResult, ':')"/>
      </xsl:when>
      <xsl:when test="$rotate!='' or $vendorEvent='rotatelog'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">ROTATE_LOG_SUCCESSFUL</xsl:when>
          <xsl:when test="$eventResult='IDS_REQUIRES_LOG_FILE'">
            <xsl:value-of select="extensions:getString('IDS_REQUIRES_LOG_FILE')" disable-output-escaping="yes"/>
          </xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$reread!='' or $vendorEvent='reread'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">REREAD_SUCCESSFUL</xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$saveConfig!='' or $vendorEvent='save'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">VENDOR_SAVE_SUCCESSFUL</xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$saveAndReread!='' or $vendorEvent='saveandreread'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">VENDOR_SAVE_AND_REREAD_SUCCESSFUL</xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="($startDaemon!='' or $vendorEvent='start') and $vendorStatus!='IDS_RUNNING' and $vendorStatus!='IDS_RUNNING_PENDING'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">START_DAEMON_SUCCESSFUL</xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="$delete!='' or $vendorEvent='delete'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">DELETE_DAEMON_SUCCESSFUL</xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="($stopDaemon!='' or $vendorEvent='stop') and $vendorStatus!='IDS_STOPPED' and $vendorStatus!='IDS_STOPPED_PENDING'">
        <xsl:choose>
          <xsl:when test="$eventResult=''">STOP_DAEMON_SUCCESSFUL</xsl:when>
          <xsl:otherwise><xsl:value-of select="$eventResult"/></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="eventResult=''">NO_MESSAGE</xsl:when>
      <xsl:otherwise><xsl:copy-of select="$eventResult" /></xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  
  <xsl:template match="/">
    <xsl:if test="starts-with($eventResult, 'ERROR_EXPIRED_SESSION:')">
      <xsl:call-template name="sessionTimeout"/>
    </xsl:if>
    <xsl:call-template name="admin"/>
  </xsl:template>
</xsl:stylesheet>
