<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalan="http://xml.apache.org/xalan" exclude-result-prefixes="extensions xalan" xmlns:fnplm="urn:fnplm:lmadmin" xmlns:extensions="urn:fnplm:lmadmin">
  <xsl:output method="html"/>
  <xsl:param name="compliance508"><xsl:value-of select="extensions:getEnv('compliance508')" disable-output-escaping="yes"/></xsl:param>
  <xsl:param name="isAdmin"><xsl:value-of select="extensions:hasPrivilege('admin')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="licenseTab"><xsl:value-of select="extensions:getEnv('licenseTab')" disable-output-escaping="yes" /></xsl:param>
  <xsl:param name="selected"><xsl:value-of select="extensions:getEnv('selected')" disable-output-escaping="yes" /></xsl:param>
  
  
  <xsl:template match="/">
    <xsl:apply-templates select="xml/fnplm:vendors" />
  </xsl:template>
  
  <xsl:template match="fnplm:vendors">
    <xsl:apply-templates select="fnplm:vendor" />
  </xsl:template>
  
  <xsl:template match="fnplm:vendor">
    <xsl:variable name="tStatus"><xsl:value-of select="./@status"/></xsl:variable>
    <xsl:variable name="vendorStatus"><xsl:value-of select="extensions:getString($tStatus)" disable-output-escaping="yes"/></xsl:variable>
    <tr>
      <td style="visibility:hidden"></td>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td width="23%" onclick="javascript:submitVendorListForm('<xsl:value-of select="./@name"/>', 'edit')"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="./@name"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td width="17%" onclick="javascript:submitVendorListForm('<xsl:value-of select="./@name"/>', 'edit')"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><div align="left"><xsl:value-of select="$vendorStatus"/></div><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td width="22%" onclick="javascript:submitVendorListForm('<xsl:value-of select="./@name"/>', 'edit')"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><div align="center"><xsl:value-of select="./@version"/></div><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>td width="10%" onclick="javascript:submitVendorListForm('<xsl:value-of select="./@name"/>', 'edit')"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><div align="center"><xsl:value-of select="./@actualPort"/></div><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/td<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
      <xsl:choose>
        <xsl:when test="$compliance508!='TRUE'">
          <td width="14%" align="center"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="javascript:submitVendorListForm('<xsl:value-of select="./@name"/>', 'edit')"  class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_ADMINISTER_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></td>
        </xsl:when>
        <xsl:otherwise>
          <td width="14%" align="center"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/vendor?vendor=<xsl:value-of select="./@name"/>&amp;event=edit&amp;compliance508=TRUE"  class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_ADMINISTER_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></td>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$compliance508!='TRUE'">
          <td width="14%" align="center"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="javascript:submitVendorListForm('<xsl:value-of select="./@name"/>', 'delete');"  class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></td>
        </xsl:when>
        <xsl:otherwise>
          <td width="14%" align="center"><xsl:if test="$isAdmin=''"><xsl:text disable-output-escaping="yes">&lt;</xsl:text>a href="/vendor?vendor=<xsl:value-of select="./@name"/>&amp;event=delete&amp;compliance508=TRUE"  class="textLink"<xsl:text disable-output-escaping="yes">&gt;</xsl:text><xsl:value-of select="extensions:getString('IDS_DELETE_LINK')" disable-output-escaping="yes"/><xsl:text disable-output-escaping="yes">&lt;</xsl:text>/a<xsl:text disable-output-escaping="yes">&gt;</xsl:text></xsl:if></td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
  </xsl:template> 
</xsl:stylesheet>
